/*** This file demonstrates, how to read the contents of the PC-Engine's */
/*** Backup-RAM */

/*** (C) Jens Ch. Restemeier */
/* Modified by Dave Shadoff */

#include <stdlib.h>
#include <stdio.h>

#define UINT  unsigned int


char *id = "HUBM";
unsigned char buffer[8192];


UINT buf2uint(int index)
{
    UINT  ret;

    ret = (UINT) buffer[index+1] * 256 + (UINT) buffer[index];
    return(ret);
}


void hexdump(int start, int len)
{
    int  i;
    unsigned char ch;

    while (len > 0) {

        /* print address: */
        printf("%4.4X: ", start);

        /* print hex digits: */
        for (i = 0; i < 16; i++) {
            if (i < len) {
                printf("%2.2X ", (UINT) buffer[start+i]);
            } else {
                printf("   ");
            }
        }

        /* print ASCII digits: */
        for (i = 0; i < 16; i++) {

            ch = buffer[start+i];

            if ((ch < ' ') || (ch > ']')) {
                ch = '.';
            }

            if (i >= len) {
                ch = ' ';
            }

            printf("%c", ch);
        }

        printf("\n");
        start += 16;
        len -= 16;
    }
}


int main(int argc, char *argv[])
{
    FILE *f;
    long fs;
    UINT size, last, i;
    UINT entry_size, xx, cnt;
    unsigned short entry_crc, crc;

    if (argc != 2) {
        printf("bmview <file> -- prints contents of PC-Engine backup files\n");
        exit(1);
    }

    if ((f=fopen(argv[1],"rb"))==NULL) {
        fprintf(stderr,"cannot open file %s !\n",argv[1]);
    }

    /* load file into buffer */
    fseek(f,0,SEEK_END);
    fs=ftell(f);
    fseek(f,0,SEEK_SET);
    if (fs > 8192) {
        printf("Error - file too large\n");
        exit(1);
    }
    fread(buffer,1,fs,f);

    if (strcmp(buffer,id)!=0) {
        fprintf(stderr,"Backup-RAM id (HUBM) not found !\n");
    }

    /* 'size' and 'last' are stored as addresses, not sizes */
    /* so they must be adjusted to find proper size         */
    size=buf2uint(4) - 0x8000;
    last=buf2uint(6) - 0x8000;

    printf("Backup-RAM size: %u (0x%X) bytes\n", size, size);
    printf("Free space:      %u (0x%X) bytes\n\n", size-last, size-last);

    i=16;
    while (i<last) {
        entry_size=buf2uint(i);
        entry_crc =buf2uint(i+2);
        xx        =buf2uint(i+4);
        /* NOTE: I think xx is used for uniqueness of entries  */
        /*       for the same game, like several RPG game-save */
        /*       entries.  I'm still not sure, though.         */

        printf("%10.10s - (uniq id = %4.4X), size = %4.4X",
               &(buffer[i+6]), xx, entry_size);

        if (entry_size == 0)
            break;

        /* calc crc */
        crc=0;
        for (cnt=4;cnt<entry_size;cnt++) {
            crc-=buffer[i+cnt];
        }

        if (crc==entry_crc)
            printf(" - crc ok !\n");
        else
            printf(" - crc broken ! (calc=%4.4X, found=%4.4X)\n", crc, entry_crc);

        /* hex-dump data */
        hexdump(i, entry_size);

        printf("\n");
        i+=entry_size;
    }
}
