
/*
 *  Copyright 1995 Microsoft Corporation. All rights reserved.
 *  Developed by Ataman Software, Inc., ftp://rmii.com/pub2/ataman,
 *       info@ataman.com
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Modified by Patrick McPhee to be a loadable library, 1997/08/10
 * Changes copyright 1997, Patrick McPhee
 * $Header: C:/ptjm/rexx/w32funcs/RCS/w32ole.cpp 1.11 2000/06/05 21:19:58 pmcphee Rel $
 */


#define STRICT
#include <windows.h>
#include <ole2ver.h>
#include <shlobj.h>
#include <malloc.h>
#include <stdio.h>

/* functions defined in this file:
 * w32createobject(ProgramId) -> handle or 0
 * w32releaseobject(handle) -> 0 (success) or 1 (failure)
 * w32getobject([FileName], [ProgramId]) -> handle or 0
 * w32callfunc(handle, name, typelist, [parm1, ...]) -> value (sets rc to 0 or 1)
 * w32callproc(handle, name, typelist, [parm1, ...]) -> 0 or 1
 * w32getproperty(handle, name) -> value (sets rc)
 * w32getsubobj(handle, name, typelist, [parm1, ...]) -> handle or 0
 * w32putproperty(object, name, typelist, value) -> 0 or 1
 */


extern "C" {
#include "w32funcs.h"
}

const unsigned long lcid = MAKELCID(MAKELANGID(LANG_ENGLISH,SUBLANG_ENGLISH_US), SORT_DEFAULT);
const int MAXARGS = 50;

#define MAXSTRING (16*1024)

static char *GetOLEErr(void);
static void Cleanup(void) {
	OleUninitialize();
}

static void OLEErr(const char *format, ...);
static void OLEStdErr(const char *name, HRESULT hr, const char *tag);

static BOOL DoChange(const char *name, VARIANT *, unsigned short type);

static BOOL fInited = FALSE;

static BOOL Init(void)
{
	DWORD dwVersion = OleBuildVersion();

	if (HIWORD(dwVersion) != rmm || LOWORD(dwVersion) < rup)
		return FALSE;

	if (FAILED(OleInitialize(NULL)))
		return FALSE;

	fInited = TRUE;
	(void)atexit(Cleanup);

	return TRUE;
}

enum CallType_t {ct_func, ct_proc, ct_subobj };

static APIRET DoInvoke(PRXSTRING iptr, PRXSTRING name, CallType_t calltype,
	unsigned short itype, PRXSTRING typelist, LONG argc, PRXSTRING argv, PRXSTRING result);

rxfunc(w32createobject)
{
   /* val = w32CreateObject(ProgramID) */
   HRESULT hr;
   IUnknown *punk = NULL;
   IDispatch *pdsp = NULL;
   CLSID clsid;
   OLECHAR ocBuf[MAXSTRING];
   char * pgid;
   char bonky[1000];
   OLECHAR *bonk;

   checkparam(1, 1) ;

   if (!fInited) {
      if (!Init()) {
         return BADGENERAL;
      }
   }

   rxstrdup(pgid, argv[0]);

   if (MultiByteToWideChar(CP_ACP, 0, pgid, -1, ocBuf, sizeof ocBuf) == 0) {
      return BADGENERAL;
   }

   hr = CLSIDFromProgID(ocBuf, &clsid);

   if (FAILED(hr)) {
      hr = CLSIDFromString(ocBuf, &clsid);
   }

   if (FAILED(hr)) {
      OLEStdErr("CreateObject", hr, "CLSIDFromProgID and CLSIDFromString failed");
   }
   else {
      /* see if there's one running already */
      hr = GetActiveObject(clsid, NULL, &punk);

      /* No? then let's try creating one */
      if (FAILED(hr))
         hr = CoCreateInstance(clsid, NULL, CLSCTX_SERVER, IID_IUnknown, (LPVOID *)&punk);

      if (FAILED(hr)) {
         OLEStdErr("CreateObject", hr, "CoCreateInstance failed");
      }

      else {
         hr = punk->QueryInterface(IID_IDispatch, (LPVOID *)&pdsp);
         if (FAILED(hr)) {
            OLEStdErr("CreateObject", hr, "QueryInterface failed");
         }
      }

   }

   if (punk) {
      punk->Release();
   }

   if (!pdsp) {
      result_zero();
   }
   else {
      result->strlength = sprintf(result->strptr, "%lx", (unsigned long)pdsp);
   }

   return 0;
}


rxfunc(w32getobject)
{
   /* val = w32GetObject([FileName], [ProgramID]) */
   HRESULT hr;
   IUnknown *punk = NULL;
   IDispatch *pdsp = NULL;
   IMoniker *pmon = NULL;
   IPersistFile *ppf = NULL;
   LPBC pbc = NULL;
   CLSID clsid;
   ULONG cEaten;
   OLECHAR ocBuf[MAXSTRING];
   char * file, * pgid;
   enum gettype_t { gt_fileonly, gt_apponly, gt_both } gettype;

   checkparam(1,2);

   if (argc == 1) {
      rxstrdup(file, argv[0]);
      gettype = gt_fileonly;
   }
   else if (!argv[0].strptr) {
      rxstrdup(pgid, argv[1]);
      gettype = gt_apponly;
   }
   else {
      rxstrdup(file, argv[0]);
      rxstrdup(pgid, argv[1]);
      gettype = gt_both;
   }


   if (!fInited) {
      if (!Init()) {
         return BADGENERAL;
      }
   }


   /* how you get the application depends on what you have to
    * work with. I've combined the apponly and both cases, because
    * there's some similarity which points up a problem in its
    * dissimilarity. Currently, if you don't have a file, you
    * can't create a new object. There should be a New call
    * if there is no active object.  */
   if (gettype == gt_apponly || gettype == gt_both) {
      if (MultiByteToWideChar(CP_ACP, 0, pgid,
          -1, ocBuf, sizeof ocBuf) == 0) {
         return BADGENERAL;
      }

      hr = CLSIDFromProgID(ocBuf, &clsid);
      if (FAILED(hr)) {
         OLEStdErr("GetObject", hr, "CLSIDFromProgID failed");
      }

      else {
         if (gettype == gt_apponly) {
            hr = GetActiveObject(clsid, NULL, &punk);
            if (FAILED(hr)) {
               OLEStdErr("GetObject", hr, "GetActiveObject failed");
            }
         }
         else {
            hr = CoCreateInstance(clsid, NULL, CLSCTX_SERVER, IID_IUnknown, (LPVOID *)&punk);
            if (FAILED(hr)) {
               OLEStdErr("GetObject", hr, "CoCreateInstance failed");
            }
            else {
               hr = punk->QueryInterface(IID_IPersistFile, (LPVOID *)&ppf);
               if (FAILED(hr)) {
                  OLEStdErr("GetObject", hr, "QueryInterface (IPersistFile) failed");
               }
               else {

                  /* make punk point to the persist file so we can get the
                   * IDispatch consistently */
                  punk->Release();
                  punk = (IUnknown *)ppf;

                  if (MultiByteToWideChar(CP_ACP, 0, file,
                      -1, ocBuf, sizeof ocBuf) == 0) {
                     OLEErr("Error converting filename: '%s' to UNICODE", file);
                  }
                  else {
                     hr = ppf->Load(ocBuf, 0);
                     if (FAILED(hr)) {
                        OLEStdErr("GetObject", hr, file);
                     }
                  }
               }
            }

            if (!FAILED(hr)) {
               hr = punk->QueryInterface(IID_IDispatch, (LPVOID *)&pdsp);
               if (FAILED(hr)) {
                  OLEStdErr("GetObject", hr, "QueryInterface failed");
               }
            } else if (gettype == gt_fileonly) {
               if (MultiByteToWideChar(CP_ACP, 0, file,
                   -1, ocBuf, sizeof ocBuf) == 0) {
                  return BADGENERAL;
               }

               hr = CreateBindCtx(0, &pbc);
               if (FAILED(hr)) {
                  OLEStdErr("GetObject", hr, "CreateBindCtx failed");
               }

               else {
                  hr = MkParseDisplayName(pbc, ocBuf, &cEaten, &pmon);
                  if (FAILED(hr)) {
                     OLEStdErr("GetObject", hr, "MkParseDisplayName failed");
                  }

                  hr = BindMoniker(pmon, 0, IID_IDispatch, (LPVOID *)&pdsp);
                  if (FAILED(hr)) {
                     OLEStdErr("GetObject", hr, "BindMoniker failed");
                  }
               }
            }
         }
      }
   }


   /* don't release ppf, since punk is pointing to it if it was
    * ever got in the first place */
   if (punk) {
           punk->Release();
   }

   if (pmon) {
           pmon->Release();
   }

   if (pbc) {
           pbc->Release();
   }

   result->strlength = sprintf(result->strptr, "%lx", (unsigned long)pdsp);

   return 0;
}


rxfunc(w32releaseobject)
{
	/* call w32ReleaseObject object */
	IDispatch *pdsp;
	char * idptr;

	checkparam(1, 1) ;

	rxstrdup(idptr, argv[0]);

	sscanf(idptr, "%lx", (unsigned long *)&pdsp);

	if (pdsp) {
		pdsp->Release();
	}

	result_zero();

	return 0;
}

rxfunc(w32callproc)
{
	/* call w32CallProc object, name, typelist, ... */

	checkparam(2, 53) ;

	return DoInvoke(argv, argv+1, ct_proc,
		DISPATCH_METHOD, argc>2 && argv[2].strlength ? argv+2:NULL, argc-3, argv+3, result);
}

rxfunc(w32callfunc)
{
	/* val = w32CallFunc(object, name, typelist, ...) */

	checkparam(2, 53) ;

	return DoInvoke(argv, argv+1, ct_func,
		DISPATCH_METHOD, argc>2 && argv[2].strlength ? argv+2:NULL, argc-3, argv+3, result);
}

/* retrieve the next instance of a collection. This could be useful for
 * someone wanting to step through all instances without worrying about count
 * and item, and it's essential for collections which don't provide count and
 * item. */
rxfunc(w32olenext)
{
   /* val = w32OleNext(object [, 'Reset' | number_to_skip]) */
   int skipval = 0;
   LPUNKNOWN punk = NULL;
   static LPENUMVARIANT pev = NULL;
   static LPDISPATCH olddsp = NULL;
   LPDISPATCH pdsp;
   HRESULT hr;
   VARIANT vRet;
   unsigned long count;
   char * thePtr;
   static OLECHAR theName[] = { '_', 'N', 'e', 'w', 'E', 'n', 'u', 'm', 0 };
   static OLECHAR * theNamePtr = theName;
   DISPID dispid;
   DWORD dwLen;

   result_zero();

   checkparam(1, 2);

   if (argc == 2) {
      char * skips;

      if (argv[1].strlength && toupper(argv[1].strptr[0]) == 'R') {
         /* reset */
         skipval = -1;
      }
      else {
         rxstrdup(skips, argv[1]);
         skipval = atoi(skips);
      }
   }

   /* get IUnknown */
   rxstrdup(thePtr, argv[0]);
   sscanf(thePtr, "%lx", (unsigned long *)&pdsp);
   
   if (pdsp && pdsp != olddsp) {
      DISPPARAMS dspp;

      if (pev) {
         pev->Release();
         pev = NULL;
      }

      VariantInit(&vRet);
      hr = pdsp->GetIDsOfNames(IID_NULL, &theNamePtr, 1, lcid, &dispid);
      if (FAILED(hr)) {
         OLEStdErr("OLENext", hr, "couldn't get ID of _NewEnum!");
         return 0;
      }
      dspp.cArgs = 0;
      dspp.rgvarg = NULL;
      dspp.rgdispidNamedArgs = NULL;
      dspp.cNamedArgs = 0;

      hr = pdsp->Invoke(dispid, IID_NULL, lcid, DISPATCH_METHOD, &dspp,
                        &vRet, NULL, NULL);

      if (!FAILED(hr) && vRet.vt == VT_UNKNOWN) {
         punk = vRet.pdispVal;
         olddsp = pdsp;
      }
      else {
         OLEStdErr("OLENext", hr, "fudge fudge fudge!");
      }
   }

   if (punk) {
      /* QueryInterface IEnumVariant */
      hr = punk->QueryInterface(IID_IEnumVARIANT, (LPVOID *)&pev);
      if (FAILED(hr)) {
         OLEStdErr("OLENext", hr, "QueryInterface failed");
      }

      punk->Release();
   }

   if (pev) {
      if (skipval == -1) {
         pev->Reset();
      }
      else if (skipval) {
         pev->Skip(skipval);
      }

      hr = pev->Next(1, &vRet, &count);

      if (FAILED(hr) || count == 0) {
         result_zero();
         pev->Release();

         olddsp = NULL;

         pev = NULL;
      }

      else {
         if (vRet.vt == VT_DISPATCH) {
            OLECHAR buf[24];
            wsprintfW(buf, L"%lx", (unsigned long)vRet.pdispVal);
            // NO VariantClear(&vRet)!!!! this does a Release() on the pdisp.
            vRet.vt = VT_BSTR;
            vRet.bstrVal = SysAllocString(buf);
         } else {

            hr = VariantChangeType(&vRet, &vRet, 0, VT_BSTR);
            if (FAILED(hr)) {
               OLEStdErr("OLENext", hr, "Failure converting return value to string");
            }
         }

         dwLen = WideCharToMultiByte(CP_ACP, 0, vRet.bstrVal, -1, NULL, 0, NULL, NULL);
         rxresize(result, dwLen+1);
         dwLen = WideCharToMultiByte(CP_ACP, 0, vRet.bstrVal, -1, result->strptr, result->strlength, NULL, NULL);
         result->strlength = strlen(result->strptr);
      }
   }

   return 0;
}


rxfunc(w32getsubobj)
{
	/* val = w32GetSubObj(object, name, typelist, ...) */

	checkparam(2, 53) ;

	return DoInvoke(argv, argv+1, ct_subobj,
		DISPATCH_METHOD|DISPATCH_PROPERTYGET, argc>2 && argv[2].strlength ? argv+2:NULL, argc-3, argv+3, result);
}

rxfunc(w32getproperty)
{
	/* val = w32GetProperty(object, name) */

	checkparam(2, 2) ;

	return DoInvoke(argv, argv+1, ct_func,
		DISPATCH_PROPERTYGET, NULL, 0, NULL, result);
}

rxfunc(w32putproperty)
{
	/* call w32PutProperty(object, name, typelist, value) */
	unsigned long cParms;

	checkparam(4,4);


	return DoInvoke(argv, argv+1, ct_proc,
		DISPATCH_PROPERTYPUT, argv+2, 1, argv+3, result);
}

static APIRET DoInvoke(PRXSTRING iptr, PRXSTRING name, CallType_t calltype,
	unsigned short itype, PRXSTRING typelist, LONG argc, PRXSTRING argv, PRXSTRING result)
{
	IDispatch *pdsp = NULL;
	HRESULT hr;
	DISPID dispid;
	DISPPARAMS dspp;
	EXCEPINFO ex;
	unsigned int bt;
	VARIANTARG vRet;
	VARIANTARG vArgs[MAXARGS];
	long l;
	char *tl = NULL;
	OLECHAR ocBuf[MAXSTRING];
	OLECHAR *tb = ocBuf;
	DISPID did;
	char * theName;
	char * theValue;

        /* in case we fail at some point... */
        result->strlength = 0;

	/* deal with the pointer to the IDispatch object */
	rxstrdup(theName, *iptr);
	sscanf(theName, "%lx", (unsigned long *)&pdsp);

        if (!pdsp) {
           rc_one();
           return 0;
        }

	/* now make the name a null-terminated string */
	rxstrdup(theName, *name);

	/* ditto for the typelist */
	if (typelist) {
		rxstrdup(tl, *typelist);
	}

	if (MultiByteToWideChar(CP_ACP, 0, theName, -1, ocBuf, sizeof ocBuf) == 0) {
	  return BADGENERAL;
	}

	hr = pdsp->GetIDsOfNames(IID_NULL, &tb, 1, lcid, &dispid);
	if (FAILED(hr)) {
		OLEStdErr(theName, hr, "GetIDsOfNames failed");
		goto errexit;
	}

	VariantInit(&vRet);

	for (l=0; l<argc; l++) {
		VariantInit(&vArgs[l]);
	}

	for (l = argc-1; l>=0; l--) {
		if (!argv[l].strptr) {
			vArgs[l].vt = VT_ERROR;
			vArgs[l].scode = DISP_E_PARAMNOTFOUND;
		} else {
		  rxstrdup(theValue, argv[argc-l-1]);
		  if (MultiByteToWideChar(CP_ACP, 0, theValue, -1,
				 ocBuf, sizeof ocBuf) == 0) {
				 return BADGENERAL;
		  }
			vArgs[l].vt = VT_BSTR;
			vArgs[l].bstrVal = SysAllocString(ocBuf);

			if (tl) {
				switch (*tl) {
					case 'b':
					  if (!DoChange(theValue, &vArgs[l], VT_BOOL)) {
							goto errexit;
					  }
						break;
					case 'c':
					  if (!DoChange(theValue, &vArgs[l], VT_CY)) {
							goto errexit;
					  }
						break;
					case 'd':
					  if (!DoChange(theValue, &vArgs[l], VT_DATE)) {
							goto errexit;
					  }
						break;
					case 'i':
					  if (!DoChange(theValue, &vArgs[l], VT_I2)) {
							goto errexit;
					  }
						break;
					case 'I':
						if (!DoChange(theValue, &vArgs[l], VT_I4)) {
								goto errexit;
						}
						break;
					case 'o':
						VariantClear(&vArgs[l]);
						vArgs[l].vt = VT_DISPATCH;
						sscanf(theValue, "%lx", &vArgs[l].pdispVal);
						break;
					case 'r':
					  if (!DoChange(theValue, &vArgs[l], VT_R4)) {
							goto errexit;
					  }
						break;
					case 'R':
					  if (!DoChange(theValue, &vArgs[l], VT_R8)) {
							goto errexit;
					  }
						break;
					case 's':
						break;
					default:
						OLEStdErr(theValue, hr, "Bad type in type list");
						goto errexit;
				}
			}
		}

		if (tl) {
			tl++;
		}
	}

	dspp.rgvarg = vArgs;
	dspp.cArgs = argc > 0 ? argc : 0;
	if (itype == DISPATCH_PROPERTYPUT) {
		did = DISPID_PROPERTYPUT;
		dspp.rgdispidNamedArgs = &did;
		dspp.cNamedArgs = 1;
	} else {
		dspp.rgdispidNamedArgs = NULL;
		dspp.cNamedArgs = 0;
	}


	hr = pdsp->Invoke(dispid, IID_NULL, lcid, itype, &dspp,
		calltype != ct_proc?&vRet:NULL, &ex, &bt);

	if (FAILED(hr)) {
		if (GetScode(hr) == DISP_E_TYPEMISMATCH) {
			OLEErr("%s: Argument %d is of an incorrect type", theName, (int)bt);
		} else if (GetScode(hr) == DISP_E_UNKNOWNNAME) {
			OLEErr("%s: unknown name", theName);
		} else if (GetScode(hr) == DISP_E_MEMBERNOTFOUND) {
			OLEErr("%s: member not found", theName);
		} else if (GetScode(hr) == DISP_E_EXCEPTION) {
			if (ex.pfnDeferredFillIn) {
				(*ex.pfnDeferredFillIn)(&ex);
			}
			OLEErr("%s: %ls: %ls", theName, ex.bstrSource, ex.bstrDescription);
			SysFreeString(ex.bstrSource);
			SysFreeString(ex.bstrDescription);
			SysFreeString(ex.bstrHelpFile);
		} else {
			OLEStdErr(theName, hr, "Invoke failed");
		}
	  goto errexit;
	}

	if (calltype != ct_proc) {
		DWORD dwLen;

		if (calltype == ct_subobj) {
			if (vRet.vt != VT_DISPATCH) {
				OLEErr("Name: %s, does not return handle to a subobject", theName);
				goto errexit;
			}
		}

		if (vRet.vt == VT_DISPATCH) {
			OLECHAR buf[24];
			wsprintfW(buf, L"%lx", (unsigned long)vRet.pdispVal);
			// NO VariantClear(&vRet)!!!! this does a Release() on the pdisp.
			vRet.vt = VT_BSTR;
			vRet.bstrVal = SysAllocString(buf);
		} else {
			hr = VariantChangeType(&vRet, &vRet, 0, VT_BSTR);
			if (FAILED(hr)) {
				OLEStdErr(theName, hr, "Failure converting return value to string");
				goto errexit;
			}
		}

	  dwLen = WideCharToMultiByte(CP_ACP, 0, vRet.bstrVal, -1, NULL, 0, NULL, NULL);

	  rxresize(result, dwLen+1);
          if (dwLen)
             result->strlength = dwLen - 1;
          else {
             result->strlength = 0;
          }
          if (dwLen > 0 &&
	      WideCharToMultiByte(CP_ACP, 0, vRet.bstrVal, -1,
			  result->strptr, dwLen+1, NULL, NULL) == 0) {
		  return BADGENERAL;
	  }
	}

	VariantClear(&vRet);

	for (l=0; l<(int)argc; l++) {
		VariantClear(&vArgs[l]);
	}

	rc_zero();

	return 0;

errexit:
	VariantClear(&vRet);

	rc_one();

	for (l=0; l<(int)argc; l++) {
		VariantClear(&vArgs[l]);
	}

	return 0;
}


static BOOL DoChange(const char *name, VARIANT *bstr, unsigned short type)
{
	 HRESULT hr;

	 hr = VariantChangeType(bstr, bstr, 0, type);
	 if (FAILED(hr)) {
		  OLEStdErr(name, hr, "Bad data conversion");
		  return FALSE;
	 }

	 return TRUE;
}

#include <stdarg.h>

static char OLEErrBuf[8192];

static void OLEErr(const char *format, ...) {
	va_list ap;

	va_start(ap, format);
	vsprintf(OLEErrBuf, format, ap);
	va_end(ap);
}


static void OLEStdErr(const char *name, HRESULT hr, const char *tag) {
	sprintf(OLEErrBuf, "OLE Error in %s: %s: SCODE=%x", name, tag, hr);
}



static char *GetOLEErr(void) {
	return OLEErrBuf;
}

rxfunc(w32olegeterror)
{
   result->strlength = sprintf(result->strptr, GetOLEErr());
   return 0;
}

extern "C" {
int createLink(const char *fullpath, const char * display, const char *path,
                      const char * dir, const char *args, int icon,
                      const char * iconpath, int hotkey)
{
   IShellLink * pShellLink;
   IPersistFile *pPersistFile;
   HRESULT hResult;
   char buf[256];
   int rc = 0;

   if (!fInited) {
      if (!Init()) {
         return BADGENERAL;
      }
   }

   hResult = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (void **)&pShellLink);

   if (!SUCCEEDED(hResult)) {
      rc = -GetLastError();
   }

   else {
      hResult = pShellLink->QueryInterface(IID_IPersistFile, (void **)&pPersistFile);

      if (!SUCCEEDED(hResult)) {
         rc = -GetLastError();
      }
   }

   if (SUCCEEDED(hResult)) {
      WCHAR wszShortcutPath[_MAX_PATH+1];
      pShellLink->SetPath (path);
      if (args)
         pShellLink->SetArguments (args);
      if (dir)
         pShellLink->SetWorkingDirectory (dir);
      pShellLink->SetDescription (display);
		
      if (hotkey) {
         pShellLink->SetHotkey(hotkey);
      }

      if (icon || iconpath) {
         if (!iconpath)
            iconpath = fullpath;
         pShellLink->SetIconLocation(iconpath, icon);
      }

      memset(wszShortcutPath, 0, sizeof(wszShortcutPath));

      MultiByteToWideChar(CP_ACP,	
                          0, 
                          fullpath, 
                          strlen(fullpath), 
                          wszShortcutPath, 
                          _MAX_PATH);

      hResult = pPersistFile->Save (wszShortcutPath, TRUE);

      if (!SUCCEEDED(hResult))
         rc = -4;

      pPersistFile->Release();
   }

   if (pShellLink)
      pShellLink->Release();

   return rc;
}
   
}
