/* shell functions:
 *  Copyright 1999 Patrick TJ McPhee. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: C:/ptjm/rexx/w32funcs/RCS/shell.c 1.2 1999/12/29 22:20:16 pmcphee Rel $
 */

/* functions defined in this file:
 * w32menuadditem([menu], [submenu], display, path, [workingdir], [arguments], [icon number], [icon file], [hot key])
 * w32menuremoveitem([menu], [submenu], display)
 * w32menumoveitem([menu], [submenu], oldname, newname)
 * w32menumove([menu], submenu, [newmenu], [newsubmenu])
 * all functions return 0 for success, or an error code.
 */ 
 
#include <windows.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include "rxproto.h"

/* defined in w32ole.cpp */
int createLink(const char *fullpath, const char * display, const char *path,
                      const char * dir, const char *args, int icon,
                      char * iconpath, int hotkey);


static int getmenupath(const char * menu, char * fullpath, unsigned long * fplen)
{
   HKEY key = 0;
   static const char regpath[] = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders",
                     mystartup[] = "Programs",
                     allstartup[] = "Common Programs",
                     mydesktop[] = "Desktop",
                     alldesktop[] = "Common Desktop";
   
   if (!strcmp(menu, "all")) {
      RegOpenKeyEx(HKEY_LOCAL_MACHINE, regpath, 0, MAXIMUM_ALLOWED, &key);
      RegQueryValueEx(key, allstartup, NULL, NULL, fullpath, fplen);
      RegCloseKey(key);
      /* fplen includes a trailing null */
      (*fplen)--;
   }
   else if (!strcmp(menu, "desktop")) {
      RegOpenKeyEx(HKEY_CURRENT_USER, regpath, 0, MAXIMUM_ALLOWED, &key);
      RegQueryValueEx(key, mydesktop, NULL, NULL, fullpath, fplen);
      RegCloseKey(key);
      (*fplen)--;
   }
   else if (!strcmp(menu, "current")) {
      RegOpenKeyEx(HKEY_CURRENT_USER, regpath, 0, MAXIMUM_ALLOWED, &key);
      RegQueryValueEx(key, mystartup, NULL, NULL, fullpath, fplen);
      RegCloseKey(key);
      (*fplen)--;
   }
   else if (!strcmp(menu, "all desktop")) {
      RegOpenKeyEx(HKEY_LOCAL_MACHINE, regpath, 0, MAXIMUM_ALLOWED, &key);
      RegQueryValueEx(key, alldesktop, NULL, NULL, fullpath, fplen);
      RegCloseKey(key);
      (*fplen)--;
   }
   else {
      strcpy(fullpath, menu);
      *fplen = strlen(menu);
   }

   return 0;
}




rxfunc(w32menuadditem)
{
   char * menu = NULL, * folder, *display, *path, *dir = NULL, *args = NULL,
        * icons, * iconpath = NULL;
   char fullpath[_MAX_PATH];
   int icon = 0;
   unsigned long fplen = sizeof(fullpath);
   int rc;

   checkparam(4,9);

   if (argv[0].strptr)
      rxstrdup(menu, argv[0]);
   else
      menu = "all";

   if (argv[1].strptr)
      rxstrdup(folder, argv[1]);
   else
      folder = "";

   rxstrdup(display, argv[2]);

   rxstrdup(path, argv[3]);


   if (argc > 4 && argv[4].strptr) {
      rxstrdup(dir, argv[4]);
   }

   if (argc > 5 && argv[5].strptr) {
      rxstrdup(args, argv[5]);
   }

   if (argc > 6 && argv[6].strptr) {
      rxstrdup(icons, argv[6]);
      icon = atoi(icons);
   }

   if (argc > 7 && argv[7].strptr) {
      rxstrdup(iconpath, argv[7]);
   }

   /* ignore the hotkey for now */

   /* find the path to the menu */
   if (getmenupath(menu, fullpath, &fplen)) {
      return BADGENERAL;
   }

   if (*folder) {
      menu = fullpath + fplen + 1;
      fplen += sprintf(fullpath+fplen, "\\%s", folder);

      /* make sure the folder's there */
      while (menu = strchr(menu, '\\')) {
         *menu = 0;
         mkdir(fullpath);
         *menu = '\\';
         menu++;
      }
      mkdir(fullpath);
   }

   /* now create the link */
   sprintf(fullpath+fplen, "\\%s.lnk", display);

   /* and call a c++ function which does the OLE stuff */
   rc = createLink(fullpath, display, path, dir, args, icon, iconpath, 0);

   result->strlength = sprintf(result->strptr, "%d", rc);

   return 0;
}

rxfunc(w32menuremoveitem)
{
   char * menu = NULL, * folder, *display;
   char fullpath[_MAX_PATH];
   unsigned long fplen = sizeof(fullpath);
   int rc;

   checkparam(3,3);

   if (argv[0].strptr)
      rxstrdup(menu, argv[0]);
   else
      menu = "all";

   if (argv[1].strptr)
      rxstrdup(folder, argv[1]);
   else
      folder = "";

   rxstrdup(display, argv[2]);

   if (getmenupath(menu, fullpath, &fplen)) {
      return BADGENERAL;
   }

   if (*folder) {
      menu = fullpath + fplen + 1;
      fplen += sprintf(fullpath+fplen, "\\%s", folder);
   }
   else {
      menu = NULL;
   }

   /* now delete the link */
   sprintf(fullpath+fplen, "\\%s.lnk", display);

   rc = remove(fullpath);

   /* and all those pesky sub-directories */
   if (menu)
      for (display = strrchr(menu, '\\'); display; display = strrchr(menu, '\\')) {
         *display = 0;
         rmdir(fullpath);
      }

   result->strlength = sprintf(result->strptr, "%d", rc);   

   return 0;
}

rxfunc(w32menumoveitem)
{
   char * menu = NULL, * folder, *display, *newname;
   char fullpath[_MAX_PATH], mullpath[_MAX_PATH];
   unsigned long fplen = sizeof(fullpath);
   int rc;

   checkparam(4,4);

   if (argv[0].strptr)
      rxstrdup(menu, argv[0]);
   else
      menu = "all";

   if (argv[1].strptr)
      rxstrdup(folder, argv[1]);
   else
      folder = "";

   rxstrdup(display, argv[2]);
   rxstrdup(newname, argv[3]);

   if (getmenupath(menu, fullpath, &fplen)) {
      return BADGENERAL;
   }

   if (*folder) {
      fplen += sprintf(fullpath+fplen, "\\%s", folder);
   }
   memcpy(mullpath, fullpath, fplen);

   /* now rename the link */
   sprintf(fullpath+fplen, "\\%s.lnk", display);
   sprintf(mullpath+fplen, "\\%s.lnk", newname);
   
   rc = rename(fullpath, mullpath);

   result->strlength = sprintf(result->strptr, "%d", rc);   

   return 0;
}

rxfunc(w32menumove)
{
   char * menu = NULL, * folder, *display, *newname;
   char fullpath[_MAX_PATH], mullpath[_MAX_PATH];
   unsigned long fplen = sizeof(fullpath);
   int rc;

   checkparam(4,4);

   if (argv[0].strptr)
      rxstrdup(menu, argv[0]);
   else
      menu = "all";

   if (argv[1].strptr)
      rxstrdup(folder, argv[1]);
   else
      folder = "";

   rxstrdup(display, argv[2]);
   rxstrdup(newname, argv[3]);

   if (getmenupath(menu, fullpath, &fplen)) {
      return BADGENERAL;
   }

   if (*folder) {
      fplen += sprintf(fullpath+fplen, "\\%s", folder);
   }
   memcpy(mullpath, fullpath, fplen);

   /* now rename the link */
   sprintf(fullpath+fplen, "\\%s.lnk", display);
   sprintf(mullpath+fplen, "\\%s.lnk", newname);

   rc = rename(fullpath, mullpath);

   result->strlength = sprintf(result->strptr, "%d", rc);

   return 0;
}
