/* this routine walks through the application event log and displays everything it
 * finds there. The optional argument 'machine' selects the machine to read from.
 * $Header: C:/ptjm/rexx/w32funcs/RCS/eventlog.rex 1.6 2000/01/12 16:40:53 pmcphee Rel $
 */

parse arg machine '/' log

/* strip leading & trailing blanks */
parse var machine machine
parse var log log

call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call w32loadfuncs

if log = '' then log = "Application"

handle=w32Openeventlog(machine,log)
if handle = 0 then do
  say 'Couldna open' log 'log.'
  exit 1
  end

start = w32getoldesteventlogrecord(handle)
finish = start + w32getnumberofeventlogrecords(handle) - 1

do j = start to finish

    rc = w32findeventlogentry(handle, j, 'FROO.')
    if rc then do
      say 'find didna work for entry' j
      exit 2
      end

    say left('source',20) froo.source
    say left('id',20) froo.id
    say left('type',20) froo.type
    say left('category',20) froo.category
    say left('numstrings', 20) froo.numstrings
    do i = 1 to froo.numstrings
      say left('string' i, 20) froo.string.i
      end
    say left('timewritten',20) froo.timewritten
    say left('timegenerated',20) froo.timegenerated
    say left('data',20) c2x(froo.data)
    say left('description',20) froo.description
    end

call w32closeeventlog(handle)

call w32dropfuncs
